package com.hero.objects.powers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.ForceFieldDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ForceField extends Power {

	private static String xmlID = "FORCEFIELD";

	private int pdLevels;

	private int edLevels;

	private int mdLevels;

	private int powdLevels;

	public ForceField(Element root) {
		super(root, ForceField.xmlID);
		canAffectPrimary = true;
	}

	@Override
	public boolean affectsCharacteristics() {
		return true;
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		ret += "(";

		boolean added = false;
		if (getPdLevels() > 0) {
			if (added) {
				ret += "/";
			}
			ret += getPdLevels() + " PD";
			added = true;
		}
		if (getEdLevels() > 0) {
			if (added) {
				ret += "/";
			}
			ret += getEdLevels() + " ED";
			added = true;
		}
		if (getMdLevels() > 0) {
			if (added) {
				ret += "/";
			}
			ret += getMdLevels() + " Mental Defense";
			added = true;
		}
		if (getPowdLevels() > 0) {
			if (added) {
				ret += "/";
			}
			ret += getPowdLevels() + " Power Defense";
			added = true;
		}
		// check for flash defense...
		ArrayList<Adder> orig = getAssignedAdders();
		ArrayList<Adder> copy = (ArrayList<Adder>) orig.clone();
		for (int i = copy.size() - 1; i >= 0; i--) {
			Adder ad = copy.get(i);
			if (ad.getXMLID().equals("FLASHDEFENSE")) {
				if (added) {
					ret += "/";
				}
				ret += ad.getLevels();
				ret += " " + ad.getAlias() + ":  "
						+ ad.getSelectedOption().getAlias();
				added = true;
				copy.remove(i);
			}
		}
		setAssignedAdders(copy);
		String adderString = getAdderString();
		setAssignedAdders(orig);

		ret += ")";

		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		String ret = "";
		return ret;
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		return new ForceFieldDialog(this, isNew, isPower);
	}

	@Override
	public double getEdIncrease() {
		return getEdLevels();
	}

	@Override
	public int getEdIncreaseLevels() {
		return getLevels();
	}

	public int getEdLevels() {
		return edLevels;
	}

	@Override
	public int getLevels() {
		return pdLevels + edLevels + mdLevels + powdLevels;
	}
	

	@Override
	public double getTotalCost() {
		double total = getBaseCost();
		ArrayList<Adder> availAds = getAvailableAdders();
		if (getLevelValue() != 0) {
			int val = getLevels();
			for (Adder a:getAssignedAdders()) {
				if (a.getXMLID().equals("FLASHDEFENSE")) {
					val += a.getLevels();
				}
			}
			double lvls = Math.floor(val / getLevelValue());
			if (val % getLevelValue() != 0 && getLevelValue() > 1) {
				lvls += 1;
			}
			total += lvls * getLevelCost();
			if (getLevelCost() < getLevelValue()) {
				if (total > 0 && total < 1) {
					total = 1;
				} else {
					total = Rounder.roundHalfDown(total);
				}
			}
		}
		for (Adder ad : getAssignedAdders()) {
			if (ad.isRequired() && !ad.getXMLID().equals("FLASHDEFENSE")) {
				total += ad.getRealCost();
			}
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isRequired() && !ad.getXMLID().equals("FLASHDEFENSE")
					&& GenericObject.findObjectByID(availAds, ad.getXMLID()) != null) {
				total += ad.getRealCost();
			}
		}
		if (total < getMinimumCost() && isMinSet()) {
			total = getMinimumCost();
		} else if (total > getMaxCost() && isMaxSet()) {
			total = getMaxCost();
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isRequired() && !ad.getXMLID().equals("FLASHDEFENSE")
					&& GenericObject.findObjectByID(availAds, ad.getXMLID()) == null) {
				total += ad.getRealCost();
			}
		}
		if (getTypes().contains("DEFENSE")
				&& HeroDesigner.getActiveHero() != null) {
			if (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
					.getPowers(), "AUTOMATON") != null) {
				Automaton auto = (Automaton) GenericObject.findObjectByID(
						HeroDesigner.getActiveHero().getPowers(), "AUTOMATON");
				if (auto.getSelectedOption().getXMLID().toUpperCase()
						.startsWith("NOSTUN")) {
					total = total * auto.getDefenseCostMultiplier();
				}
			}
		}
		return total;
	}

	@Override
	public int getMdLevels() {
		return mdLevels;
	}

	@Override
	public double getPdIncrease() {
		return getPdLevels();
	}

	@Override
	public int getPdIncreaseLevels() {
		return getLevels();
	}

	public int getPdLevels() {
		return pdLevels;
	}

	public int getPowdLevels() {
		return powdLevels;
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		root.setAttribute("PDLEVELS", "" + pdLevels);
		root.setAttribute("EDLEVELS", "" + edLevels);
		root.setAttribute("MDLEVELS", "" + mdLevels);
		root.setAttribute("POWDLEVELS", "" + powdLevels);
		return root;
	}

	@Override
	public boolean resistantDefenses() {
		return true;
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		String check = XMLUtility.getValue(root, "PDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				pdLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(root, "EDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				edLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		setLevels(edLevels + pdLevels);
		check = XMLUtility.getValue(root, "MDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				mdLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		setLevels(edLevels + pdLevels);
		check = XMLUtility.getValue(root, "POWDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				powdLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		setLevels(edLevels + pdLevels + mdLevels + powdLevels);
	}

	public void setEdLevels(int edLevels) {
		this.edLevels = edLevels;
		setLevels(getPdLevels() + getEdLevels() + getMdLevels()
				+ getPowdLevels());
	}

	public void setMdLevels(int val) {
		mdLevels = val;
		setLevels(getPdLevels() + getEdLevels() + getMdLevels()
				+ getPowdLevels());
	}

	public void setPdLevels(int pdLevels) {
		this.pdLevels = pdLevels;
		setLevels(getPdLevels() + getEdLevels() + getMdLevels()
				+ getPowdLevels());
	}

	public void setPowdLevels(int val) {
		powdLevels = val;
		setLevels(getPdLevels() + getEdLevels() + getMdLevels()
				+ getPowdLevels());
	}
}